/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.target.formulator;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.db.framework.topology.DBHomeImpl;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.shard.DatabaseProductType;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.target.formulator.HomeSupporter;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.target.formulator.IHomeFormulator;
import com.oracle.glcm.patch.auto.product.ProductType;
import com.oracle.glcm.patch.auto.topology.Host;
import com.oracle.glcm.patch.auto.topology.HostImpl;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.RACDatabase;
import java.util.List;

public class RACHomeFormulator
extends HomeSupporter
implements IHomeFormulator {
    private boolean isShardedDatabase = false;
    private List<String> shardGroupOptions = null;
    private List<String> shardSpaceOptions = null;

    public RACHomeFormulator(boolean isShardedDatabase, List<String> shardGroupOptions, List<String> shardSpaceOptions) {
        this.isShardedDatabase = isShardedDatabase;
        this.shardGroupOptions = shardGroupOptions;
        this.shardSpaceOptions = shardSpaceOptions;
    }

    @Override
    public DBHomeImpl createHome(AbstractBaseTarget shard, HostImpl host, boolean isOgg, String shardingType, OracleHome oracleHome) {
        ProductType productType = null;
        DBHomeImpl targetHome = new DBHomeImpl();
        RACDatabase racDatabase = (RACDatabase)shard;
        targetHome.setTargetType("rac");
        targetHome.setDrsetNumber(racDatabase.getShardProperty().getDrsetNumber());
        targetHome.setTargetName(racDatabase.getDatabaseName());
        targetHome.setOwner(!StringUtil.isNullOrEmpty((String)oracleHome.getOwner()) ? oracleHome.getOwner() : racDatabase.getOwner());
        boolean isPrimary = racDatabase.getPrimary();
        if (this.isShardedDatabase) {
            productType = this.setProductTypeForSDB(isOgg, isPrimary, targetHome);
            targetHome.setShardGroupName(racDatabase.getShardProperty().getShardGroupName());
            targetHome.setShardSpaceName(racDatabase.getShardProperty().getShardSpaceName());
        } else if (this.shardGroupOptions != null || this.shardSpaceOptions != null) {
            productType = new DatabaseProductType();
            if (this.shardGroupOptions != null) {
                targetHome.setShardGroupName(racDatabase.getShardProperty().getShardGroupName());
            } else if (isOgg) {
                targetHome.setShardSpaceName(racDatabase.getShardProperty().getShardSpaceName());
            } else {
                productType = this.setProductTypeForDG(isPrimary, targetHome);
            }
        } else {
            productType = this.setProductTypeForDG(isPrimary, targetHome);
            targetHome.setShardGroupName(racDatabase.getShardProperty().getShardGroupName());
            targetHome.setShardSpaceName(racDatabase.getShardProperty().getShardSpaceName());
        }
        if (oracleHome.getIsShared()) {
            targetHome.setSharedHome(true);
        }
        targetHome.setShardingType(shardingType);
        targetHome.addProductType(productType);
        String homeLoc = racDatabase.getShardProperty().getOraceHomePath();
        targetHome.setLocation(!StringUtil.isNullOrEmpty((String)oracleHome.getPath()) ? oracleHome.getPath() : homeLoc);
        targetHome.setHost((Host)host);
        return targetHome;
    }
}

