/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product;

import com.oracle.glcm.patch.auto.db.framework.sdk.PatchPlanException;
import com.oracle.glcm.patch.auto.db.framework.sdk.cookies.CloneCookie;
import com.oracle.glcm.patch.auto.db.framework.sdk.cookies.SkipTargetCookie;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.product.patch.CRSApplicabilityTarget;
import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.CRSCluster;
import dbmodel.db_crs.DBInstance;
import dbmodel.db_crs.HAS;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.PhaseType;

public class SIPatchingContext {
    final Logger logger = Logger.getLogger(SIPatchingContext.class.getName());
    protected final SystemInstance systemInstance;
    protected final ConfigGraph configGraph;
    protected final boolean switchBackAfterMigrate;

    public SIPatchingContext(SystemInstance systemInstance, ConfigGraph configGraph, boolean switchBackAfterMigrate) {
        this.systemInstance = systemInstance;
        this.configGraph = configGraph;
        this.switchBackAfterMigrate = switchBackAfterMigrate;
    }

    public void dontTouchOracleHome(OracleHome oh, PhaseType phases) {
        assert (oh != null);
        if (oh == null) {
            throw new IllegalArgumentException("Argument cannot be null.");
        }
        SkipTargetCookie skip = new SkipTargetCookie(new PhaseType[0]);
        this.logger.config("Not going to touch Oracle Home: " + oh.getPath() + " on host(s):" + oh.getHosts());
        oh.setProperty((Object)skip);
        this.dontTouchTargetsRunningFrom(oh, phases);
    }

    public void dontTouchTargetsRunningFrom(OracleHome oh, PhaseType ... phases) {
        assert (oh != null);
        if (oh == null) {
            throw new IllegalArgumentException("Argument cannot be null.");
        }
        SkipTargetCookie skip = new SkipTargetCookie(phases);
        if (CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.crs.name().equals(oh.getHomeType())) {
            this.logger.config("Not going to touch CRS&HAS running from Oracle Home: " + oh.getPath() + " on host(s):" + oh.getHosts());
            List<HAS> hass = this.configGraph.getConnectedTargets((AbstractBaseTarget)oh, HAS.class);
            this.logger.config("Found HAS running form OH=" + oh.getPath() + " " + hass);
            for (HAS has : hass) {
                has.setProperty((Object)skip);
                CRSCluster crs = has.getCluster();
                this.logger.config("Found CRS running form OH=" + oh.getPath() + " " + crs + " marking as skip.");
                crs.setProperty((Object)skip);
            }
            return;
        }
        if (CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.name().equals(oh.getHomeType())) {
            this.logger.config("Not going to touch RacDB and RACInstances running from Oracle Home: " + oh.getPath() + " on host(s):" + oh.getHosts());
            List<RACDBInstance> dbis = this.configGraph.getConnectedTargets((AbstractBaseTarget)oh, RACDBInstance.class);
            this.logger.config("Found RACInstance running form OH=" + oh.getPath() + " " + dbis);
            for (RACDBInstance dbi : dbis) {
                dbi.setProperty((Object)skip);
                RACDatabase db = dbi.getDbRAC();
                this.logger.config("Found RACDatabase running form OH=" + oh.getPath() + " " + db + " marking it as skip.");
                db.setProperty((Object)skip);
            }
            return;
        }
    }

    public void dontTouchRacDatabase(RACDatabase db, PhaseType ... phases) {
        assert (db != null);
        if (db == null) {
            throw new IllegalArgumentException("Argument cannot be null.");
        }
        SkipTargetCookie skip = new SkipTargetCookie(phases);
        this.logger.config("Not going to touch RACDatabase: " + db);
        db.setProperty((Object)skip);
        for (RACDBInstance dbi : this.l(db.getDbInstances())) {
            this.logger.config("Not going to touch RACDbInstance: " + dbi);
            dbi.setProperty((Object)skip);
            OracleHome oh = dbi.getRuns_from();
            if (oh == null) {
                List<OracleHome> ohs = this.configGraph.getConnectedTargets((AbstractBaseTarget)dbi, OracleHome.class);
                if (ohs.size() != 1) {
                    throw new PatchPlanException.InvalidConfigException("RACDBInstance: " + dbi + " does not have oracle home associated with it!");
                }
                oh = ohs.get(0);
            }
            boolean allSkipped = true;
            List<DBInstance> rdbis = this.configGraph.getConnectedTargets((AbstractBaseTarget)oh, DBInstance.class);
            for (DBInstance rdbi : rdbis) {
                if (rdbi.getProperty(SkipTargetCookie.class) != null) continue;
                allSkipped = false;
                break;
            }
            if (allSkipped) {
                this.logger.config("All the RACDbInstances:" + rdbis + " running from OH: " + oh.getPath() + " mounted on Host(s):" + oh.getHosts() + " are being skipped. Hence, skipping the OH itself ");
                oh.setProperty((Object)skip);
                continue;
            }
            this.logger.config("There are RACDbInstances:" + rdbis + " running from OH: " + oh.getPath() + " mounted on Host(s):" + oh.getHosts() + " are NOT being skipped. Hence, NOT skipping the OH itself ");
        }
    }

    public void dontTouchRACOracleHomeForCloneAction(OracleHome oh) {
        assert (oh != null);
        if (oh == null) {
            throw new IllegalArgumentException("Argument cannot be null.");
        }
        ArrayList<String> applicableActionTag = new ArrayList<String>();
        applicableActionTag.add("clone_action");
        SkipTargetCookie skip = new SkipTargetCookie(applicableActionTag);
        this.logger.config("Not going to touch Oracle Home: " + oh.getPath() + " on host(s):" + oh.getHosts());
        if (CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.name().equals(oh.getHomeType())) {
            oh.setProperty((Object)skip);
            this.dontTouchRACDatabaseRunningFrom(oh);
        }
    }

    public void dontTouchRACDatabaseRunningFrom(OracleHome oh) {
        assert (oh != null);
        if (oh == null) {
            throw new IllegalArgumentException("Argument cannot be null.");
        }
        ArrayList<String> applicableActionTag = new ArrayList<String>();
        applicableActionTag.add("clone_action");
        SkipTargetCookie skip = new SkipTargetCookie(applicableActionTag);
        this.logger.config("Not going to touch RacDB and RACInstances running from Oracle Home: " + oh.getPath() + " on host(s):" + oh.getHosts());
        List<RACDBInstance> dbis = this.configGraph.getConnectedTargets((AbstractBaseTarget)oh, RACDBInstance.class);
        this.logger.config("Found RACInstance running form OH=" + oh.getPath() + " " + dbis);
        for (RACDBInstance dbi : dbis) {
            dbi.setProperty((Object)skip);
            RACDatabase db = dbi.getDbRAC();
            this.logger.config("Found RACDatabase running form OH=" + oh.getPath() + " " + db + " marking it as skip.");
            db.setProperty((Object)skip);
        }
    }

    public void dontTouchGI(PhaseType ... phases) {
        SkipTargetCookie skip = new SkipTargetCookie(phases);
        List crss = this.systemInstance.getTargetsOfType(CRSCluster.class);
        assert (crss.size() == 1);
        if (crss.size() != 1) {
            throw new IllegalStateException("Found none or more than one CRSCluster objects in the systemInstance: " + crss);
        }
        CRSCluster crs = (CRSCluster)crss.get(0);
        this.logger.config("Not going to touch CRSCluster: " + crs);
        crs.setProperty((Object)skip);
        for (HAS has : this.l(crs.getHAS())) {
            this.logger.config("Not going to touch HAS: " + has);
            has.setProperty((Object)skip);
            OracleHome oh = has.getRuns_from();
            boolean allSkipped = true;
            List<HAS> hass = this.configGraph.getConnectedTargets((AbstractBaseTarget)oh, HAS.class);
            for (HAS _has : hass) {
                if (_has.getProperty(SkipTargetCookie.class) != null) continue;
                allSkipped = false;
                break;
            }
            if (allSkipped) {
                this.logger.config("All the HAS:" + hass + " running from OH: " + oh.getPath() + " mounted on Host(s):" + oh.getHosts() + " are being skipped. Hence, skipping the OH itself ");
                oh.setProperty((Object)skip);
                continue;
            }
            this.logger.config("There are HAS:" + hass + " running from OH: " + oh.getPath() + " mounted on Host(s):" + oh.getHosts() + " are NOT being skipped. Hence, NOT skipping the OH itself ");
        }
    }

    public void resetAllPatchingPropertiesOnTargets() {
        for (BaseClass bc : this.systemInstance.getEntities()) {
            bc.setProperty(SkipTargetCookie.class, null);
            bc.setProperty(CloneCookie.class, null);
        }
    }

    private <T> List<T> l(List<T> in) {
        if (in == null) {
            return Collections.emptyList();
        }
        return in;
    }

    public void setCloneLocationForOracleHomeOnAllNodes(String oracleHome, String clonedOracleHome) {
        this.logger.fine("Setting clone cookie for OracleHomePath: " + oracleHome + " as: " + clonedOracleHome);
        for (OracleHome oh : this.systemInstance.getTargetsOfType(OracleHome.class)) {
            CloneCookie cc;
            if (!oh.getPath().equals(oracleHome)) continue;
            if (oh.getHomeType().equals((Object)CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac)) {
                for (RACDatabase racDB : this.configGraph.getTargets(RACDatabase.class)) {
                    if (!racDB.getOracleHome().equals(oh.getPath())) continue;
                    this.setCloneLocationForRACDatabase(racDB, clonedOracleHome);
                }
            }
            if (oh.getProperty(CloneCookie.class) != null) {
                cc = (CloneCookie)oh.getProperty(CloneCookie.class);
                this.logger.info("Clone cookie already set (hence skipping) for OracleHomePath: " + oracleHome + " as: " + cc.getClonePath());
                continue;
            }
            if (this.switchBackAfterMigrate) {
                this.logger.fine("Scenario is switchback after migrate, hence swapping OH path with clone location. Setting clone cookie for OracleHomePath: " + oracleHome + " (host: " + oh.getHosts() + ") as: " + clonedOracleHome);
                cc = new CloneCookie();
                cc.setClonePath(oh.getPath());
                oh.setPath(clonedOracleHome);
                oh.setProperty((Object)cc);
                continue;
            }
            this.logger.finest("Setting clone cookie for OracleHomePath: " + oracleHome + " (host: " + oh.getHosts() + ") as: " + clonedOracleHome);
            cc = new CloneCookie();
            cc.setClonePath(clonedOracleHome);
            oh.setProperty((Object)cc);
        }
    }

    public void setSkipCookieForRACCloneAction() {
        String candidateOH;
        if (PatchPlanner.getInstance().getOPlanEnv().getProperty("MoveConfigToOH") != null && (candidateOH = PatchPlanner.getInstance().getOPlanEnv().getProperty("MoveConfigToOH")) != null && candidateOH.length() > 0) {
            String sourcOH = System.getenv("ORACLE_HOME");
            List OHList = this.systemInstance.getTargetsOfType(OracleHome.class);
            if (OHList != null && !OHList.isEmpty()) {
                for (int i = 0; i < OHList.size(); ++i) {
                    OracleHome dbOH = (OracleHome)OHList.get(i);
                    if (!dbOH.getPath().equals(sourcOH)) continue;
                    this.logger.log(Level.INFO, "Set clone skip to RAC Database" + dbOH.getPath());
                    this.dontTouchRACOracleHomeForCloneAction(dbOH);
                    this.setCloneLocationForOracleHomeOnAllNodes(sourcOH, candidateOH);
                }
            }
        }
    }

    public void setCloneLocationForRACDatabase(RACDatabase racDB, String clonedOracleHome) {
        this.logger.fine("Setting clone cookie for RAC Database: " + racDB.getDatabaseName() + " as: " + clonedOracleHome);
        for (RACDatabase rac : this.systemInstance.getTargetsOfType(RACDatabase.class)) {
            CloneCookie cc;
            if (!rac.getDatabaseName().equals(racDB.getDatabaseName())) continue;
            if (rac.getProperty(CloneCookie.class) != null) {
                cc = (CloneCookie)rac.getProperty(CloneCookie.class);
                this.logger.info("Clone cookie already set (hence skipping) for RAC Database: " + racDB.getDatabaseName() + " as: " + cc.getClonePath());
                continue;
            }
            this.logger.finest("Setting clone cookie for RAC Database: " + racDB.getDatabaseName() + " as: " + clonedOracleHome);
            cc = new CloneCookie();
            cc.setClonePath(clonedOracleHome);
            rac.setProperty((Object)cc);
            for (RACDBInstance inst : this.configGraph.getConnectedTargets((AbstractBaseTarget)rac, RACDBInstance.class)) {
                inst.setProperty((Object)cc);
            }
        }
    }

    @Deprecated
    public void setCloneLocationForRACDatabase(RACDatabase racDB, String clonedOracleHome, String cloneOracleHomeName) {
        this.logger.fine("Setting clone cookie for RAC Database: " + racDB.getDatabaseName() + " as: " + clonedOracleHome + " name:" + cloneOracleHomeName);
        for (RACDatabase rac : this.systemInstance.getTargetsOfType(RACDatabase.class)) {
            CloneCookie cc;
            if (!rac.getDatabaseName().equals(racDB.getDatabaseName())) continue;
            if (rac.getProperty(CloneCookie.class) != null) {
                cc = (CloneCookie)rac.getProperty(CloneCookie.class);
                this.logger.info("Clone cookie already set (hence skipping) for RAC Database: " + racDB.getDatabaseName() + " as: " + cc.getClonePath() + " name:" + cc.getCloneName());
                continue;
            }
            this.logger.finest("Setting clone cookie for RAC Database: " + racDB.getDatabaseName() + " as: " + clonedOracleHome + " name:" + cloneOracleHomeName);
            cc = new CloneCookie();
            cc.setClonePath(clonedOracleHome);
            cc.setCloneName(cloneOracleHomeName);
            rac.setProperty((Object)cc);
            for (RACDBInstance inst : this.configGraph.getConnectedTargets((AbstractBaseTarget)rac, RACDBInstance.class)) {
                inst.setProperty((Object)cc);
            }
        }
    }

    public void dontTouchSIDB(SIDatabase sidb, PhaseType ... phases) {
        assert (sidb != null);
        if (sidb == null) {
            throw new IllegalArgumentException("Argument cannot be null.");
        }
        SkipTargetCookie skip = new SkipTargetCookie(phases);
        this.logger.config("Not going to touch SIDatabase: " + sidb);
        sidb.setProperty((Object)skip);
        OracleHome oh = sidb.getRuns_from();
        if (oh == null) {
            List<OracleHome> ohs = this.configGraph.getConnectedTargets((AbstractBaseTarget)sidb, OracleHome.class);
            if (ohs.size() != 1) {
                throw new PatchPlanException.InvalidConfigException("SIDatabase: " + sidb + " does not have oracle home associated with it!");
            }
            oh = ohs.get(0);
        }
        if (oh.getHomeType().equals("sidb")) {
            oh.setProperty((Object)skip);
        }
    }

    public void dontTouchSIHA(PhaseType ... phases) {
        SkipTargetCookie skip = new SkipTargetCookie(phases);
        List siha = this.systemInstance.getTargetsOfType(HAS.class);
        assert (siha.size() == 1);
        if (siha.size() != 1) {
            throw new IllegalStateException("Found none or more than one SIHA objects in the systemInstance: " + siha);
        }
        HAS has = (HAS)siha.get(0);
        this.logger.config("Not going to touch SIHA: " + has);
        has.setProperty((Object)skip);
        OracleHome oh = has.getRuns_from();
        if (oh != null) {
            oh.setProperty((Object)skip);
        }
    }
}

