/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.sdk.ExecutionMode;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.engine.CRSContextPopulator;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import java.util.ArrayList;
import java.util.List;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.LifecycleAction;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class OracleHomeRACOneLifecycle
extends Command {
    protected String type = DBCommandActionType.relocateout.toString();
    protected Strategy s = Strategy.MANUAL;
    private List<RACDBInstance> activeRACOneDBInst = null;

    public OracleHomeRACOneLifecycle(ActionType automationAction, String type, Strategy s) {
        super(automationAction);
        this.type = type;
        this.s = s;
    }

    private boolean skipStepForRACAndInActiveRACOneDB(CommandContext context) {
        OracleHome oh = context.getTarget(OracleHome.class);
        Host host = context.getTarget(Host.class);
        this.activeRACOneDBInst = this.findRacOneInstance(oh, host);
        return this.activeRACOneDBInst == null || this.activeRACOneDBInst.isEmpty();
    }

    private List<RACDBInstance> findRacOneInstance(OracleHome oh, Host host) {
        ArrayList<RACDBInstance> racOneInstanceList = new ArrayList<RACDBInstance>();
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        List<RACDatabase> racDBList = configGraph.getTargets(RACDatabase.class);
        block0: for (RACDatabase racDB : racDBList) {
            for (RACDBInstance racDBInst : racDB.getDbInstances()) {
                if (!racDBInst.getRuns_from().getPath().equals(oh.getPath()) || !racDBInst.getHost().getHostName().equals(host.getHostName()) || !racDBInst.getDbRAC().getDatabaseType().equals("racone") || !racDBInst.getIsRunning().equals("yes")) continue;
                racOneInstanceList.add(racDBInst);
                continue block0;
            }
        }
        return racOneInstanceList;
    }

    public List<String> getShellCommands(CommandContext context) {
        OracleHome oh = context.getTarget(OracleHome.class);
        Host host = context.getTarget(Host.class);
        ArrayList<String> cmds = new ArrayList<String>();
        for (RACDBInstance racOneInstance : this.activeRACOneDBInst) {
            if (DBCommandActionType.relocateout.toString().equalsIgnoreCase(this.type)) {
                List dbInstances = racOneInstance.getDbRAC().getDbInstances();
                for (RACDBInstance inActiveRACOneDBInst : dbInstances) {
                    if (!"no".equals(inActiveRACOneDBInst.getIsRunning())) continue;
                    host = inActiveRACOneDBInst.getHost();
                    break;
                }
            }
            String relocateCmd = "ORACLE_HOME=" + oh.getPath() + " " + oh.getPath() + "/bin/srvctl relocate database -d " + racOneInstance.getDbRAC().getDatabaseName() + " -n " + host.getHostName() + " -w 30 -v";
            cmds.add(relocateCmd);
        }
        return cmds;
    }

    public ExecutionStep getExecutionStep(CommandContext context) {
        ExecutionStep executionStep = CommandUtils.getBasicExecutionStep(this.automationAction, context, null);
        for (String cmd : this.getShellCommands(context)) {
            executionStep.getCommand().add(new ExecutionStep.Command(cmd));
        }
        return executionStep;
    }

    @Override
    public List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        List<? extends AbstractBaseTarget> ohs = actsOnlyOnTargets;
        for (OracleHome oracleHome : ohs) {
            CommandContext context = contextPopulator.populateContext(g, (AbstractBaseTarget)oracleHome, this.getHost());
            if (!CommandUtils.shouldShutdownRACInstance(this.getPatchingPhase(), oracleHome.getPath()) || this.skipStepForRACAndInActiveRACOneDB(context)) continue;
            if (this.automationAction.isActsOnClone()) {
                contextPopulator.fixCloneContext(context);
                OracleHome oh = context.getFirstTarget(OracleHome.class);
                if (oh.getOriginalOracleHome() != null && oh.getOriginalOracleHome().getPath().equals(oh.getPath())) continue;
            }
            ExecutionStep step = this.getExecutionStep(context);
            if (this.s.equals((Object)Strategy.DCLI)) {
                step.setHost(g.getLocalHost());
            }
            steps.add(step);
        }
        return steps;
    }

    @Override
    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
        return g.getTargets(OracleHome.class, this.automationAction.getStripe());
    }

    @Override
    protected boolean includeTargetByVersion(ConfigGraph configGraph, AbstractBaseTarget abstractBaseTarget, ExecutionMode executionMode) {
        return true;
    }

    public static class Builder
    implements CommandBuilder<OracleHomeRACOneLifecycle> {
        @Override
        public OracleHomeRACOneLifecycle getCommand(ActionType a, Strategy s) {
            if (!(a instanceof LifecycleAction) || a.getActsOn() == null || !a.getActsOn().equals("OracleHomeRACOne")) {
                return null;
            }
            OracleHomeRACOneLifecycle com = new OracleHomeRACOneLifecycle(a, a.getType(), s);
            return com;
        }
    }
}

