/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.SimpleShellCommand;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanInternalException;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import dbmodel.common.OracleHome;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class UnlockOH
extends SimpleShellCommand {
    Logger logger = Logger.getLogger(UnlockOH.class.getName());

    public UnlockOH(ActionType automationAction) {
        super(automationAction);
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        this.logger.log(Level.FINE, "Generating UnlockOH command based on the crs version.");
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        String ohPath = oh.getPath();
        this.logger.log(Level.FINE, "OracleHome path = " + ohPath);
        String version = PatchPlanner.getInstance().getConfigGraph().getRootVertex().getVersion();
        if (version == null) {
            throw new PatchPlanInternalException("The version of top target in SystemInstance is missing");
        }
        this.logger.log(Level.FINE, "Crs Version is " + version);
        String plPath = null;
        String cmd = null;
        if (version.startsWith("11.2.0.2")) {
            plPath = ohPath + "/OPatch/crs/patch112.pl";
            cmd = "/usr/bin/perl " + plPath + " -unlock" + " -desthome=" + ohPath;
        } else if (version.startsWith("11.2") && !version.startsWith("11.2.0.1")) {
            String destcrsHome = "";
            if ("siha".equals(oh.getHomeType())) {
                plPath = ohPath + "/crs/install/roothas.pl";
                destcrsHome = " -dstcrsHome " + ohPath;
            } else if ("crs".equals(oh.getHomeType())) {
                plPath = ohPath + "/crs/install/rootcrs.pl";
                destcrsHome = " -destcrshome=" + ohPath;
            }
            cmd = "/usr/bin/perl " + plPath + " -unlock" + destcrsHome;
        }
        return Collections.singletonList(cmd);
    }

    public static class Builder
    implements CommandBuilder<UnlockOH> {
        @Override
        public UnlockOH getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || !a.getType().equals(DBCommandActionType.unlockoh.toString())) {
                return null;
            }
            UnlockOH com = new UnlockOH(a);
            return com;
        }
    }
}

