/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.oop.sessioninfo;

import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfo;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class OOPSessionCookie
implements Serializable {
    private static final long serialVersionUID = 8315598029732510028L;
    private OOPSessionState sessionState = OOPSessionState.ACTIVE;
    private OOPOperationType operationType;
    private boolean isRemotePatching = false;
    private Map<String, OOPSessionInfo> cookie = new ConcurrentHashMap<String, OOPSessionInfo>();

    public void addSessionInfo(String host, OOPSessionInfo sessionInfo) {
        this.cookie.put(host.toLowerCase(), sessionInfo);
    }

    public void removeSessionInfo(String host) {
        this.cookie.remove(host.toLowerCase());
    }

    public OOPSessionInfo getOOPSessionInfo(String host) {
        return this.cookie.get(host.toLowerCase());
    }

    public Set<Map.Entry<String, OOPSessionInfo>> getOOPSessionInfoList() {
        return this.cookie.entrySet();
    }

    public int getCookieSize() {
        return this.cookie.size();
    }

    public void sessionActive() {
        this.sessionState = OOPSessionState.ACTIVE;
    }

    public void sessionCompleted() {
        this.sessionState = OOPSessionState.COMPLETED;
    }

    public boolean isSessionCompleted() {
        return this.sessionState == OOPSessionState.COMPLETED;
    }

    public void setOperationType(OOPOperationType operationType) {
        this.operationType = operationType;
    }

    public OOPOperationType getOperationType() {
        return this.operationType;
    }

    public boolean isRemotePatching() {
        return this.isRemotePatching;
    }

    public void setRemotePatching(boolean isRemotePatching) {
        this.isRemotePatching = isRemotePatching;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nSession Cookie...");
        sb.append("\nsessionState: " + this.sessionState.name());
        sb.append("\noperationType: " + this.operationType.name());
        sb.append("\nisRemotePatching: " + this.isRemotePatching);
        for (String host : this.cookie.keySet()) {
            sb.append("\nSessionInfo for host: " + host);
            OOPSessionInfo sessionInfo = this.cookie.get(host);
            sb.append("\nSessionInfo" + sessionInfo.toString());
        }
        return sb.toString();
    }

    public static enum OOPSessionState {
        ACTIVE,
        COMPLETED;

    }

    public static enum OOPOperationType {
        APPLY,
        PREPARE,
        SWITCH,
        ROLLBACK;

    }
}

