/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.patchlevel;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.patchlevel.OracleHomePatchLevel;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.Host;
import java.io.File;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.opatchauto.core.binary.OPatchPatchInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OracleHomePatchLevelXMLFormatter {
    private Logger logger = Logger.getLogger(OracleHomePatchLevelXMLFormatter.class.getName());

    public void formatReport(String reportLocation, Map<Host, OracleHomePatchLevel> ohPatchLevelOnHost, String forHost) throws OPatchAutoException {
        this.logger.info("resultLoc: " + reportLocation);
        Map<Host, OracleHomePatchLevel> oracleHomePatchLevels = ohPatchLevelOnHost;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("home_patch_level");
            doc.appendChild(rootElement);
            Attr fileversion = doc.createAttribute("version");
            fileversion.setValue("1.0");
            rootElement.setAttributeNode(fileversion);
            for (Host host : oracleHomePatchLevels.keySet()) {
                Element node = doc.createElement("host");
                rootElement.appendChild(node);
                Attr nodeName = doc.createAttribute("name");
                nodeName.setValue(host.getHost());
                node.setAttributeNode(nodeName);
                this.addOracleHomesToNode(doc, node, oracleHomePatchLevels.get(host), host.getHomes());
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            File reportLoc = new File(reportLocation);
            StreamResult result = new StreamResult(reportLoc);
            transformer.transform(source, result);
            if (this.logger.isLoggable(Level.FINEST)) {
                StringWriter writer = new StringWriter();
                transformer.transform(source, new StreamResult(writer));
                this.logger.finest("PatchReport.xml content start for " + forHost + "\n" + writer.toString() + "\nPatchReport.xml content end");
            }
        }
        catch (ParserConfigurationException e) {
            this.logger.info("ParserConfigurationException: " + e.getMessage());
            throw new OPatchAutoException((Throwable)e);
        }
        catch (TransformerException e) {
            this.logger.info("TransformerException: " + e.getMessage());
            throw new OPatchAutoException((Throwable)e);
        }
    }

    private void addOracleHomesToNode(Document doc, Element node, OracleHomePatchLevel homePatchLevel, Set<Home> ohList) {
        for (String oracleHomePath : homePatchLevel.getOracleHomePatchLevel().keySet()) {
            Element oracleHome = doc.createElement("oracleHome");
            node.appendChild(oracleHome);
            Attr ohPath = doc.createAttribute("path");
            ohPath.setValue(oracleHomePath);
            oracleHome.setAttributeNode(ohPath);
            Attr type = doc.createAttribute("type");
            for (Home home : ohList) {
                if (!home.getLocation().equals(oracleHomePath)) continue;
                type.setValue(this.getHomeType(home));
                break;
            }
            oracleHome.setAttributeNode(type);
            this.addPatches(doc, oracleHome, homePatchLevel.getOracleHomePatchLevel().get(oracleHomePath));
        }
    }

    private void addPatches(Document doc, Element oracleHome, List<OPatchPatchInfo> patchBeans) {
        Element patches = doc.createElement("patches");
        oracleHome.appendChild(patches);
        for (OPatchPatchInfo patchBean : patchBeans) {
            this.addPatch(doc, patches, patchBean);
        }
    }

    private void addPatch(Document doc, Element patches, OPatchPatchInfo patchBean) {
        Element patch = doc.createElement("patch");
        patches.appendChild(patch);
        this.addPatchAttributes(doc, patch, patchBean.getPatchID(), String.valueOf(patchBean.isSQLPatch()), patchBean.getUniquePatchID());
    }

    private void addPatchAttributes(Document doc, Element patch, String patchID, String isSqlPatch, String bugsFixed) {
        Attr patchid = doc.createAttribute("id");
        patchid.setValue(patchID);
        patch.setAttributeNode(patchid);
        Attr sqlPatch = doc.createAttribute("isSqlPatch");
        sqlPatch.setValue(isSqlPatch);
        patch.setAttributeNode(sqlPatch);
        Attr bugFixed = doc.createAttribute("unique_patch_id");
        bugFixed.setValue(bugsFixed);
        patch.setAttributeNode(bugFixed);
    }

    private String getHomeType(Home home) {
        String homeType = "";
        boolean isCrs = DBPatchingUtil.isCrsHome(home);
        homeType = isCrs ? "cluster" : "database";
        return homeType;
    }
}

