/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.report.patches;

import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.report.bindings.Home;
import com.oracle.glcm.patch.auto.report.bindings.Host;
import com.oracle.glcm.patch.auto.report.patches.PatchReporting;
import dbmodel.common.OracleHome;
import java.util.List;

public class DBPatchReporting
extends PatchReporting {
    public boolean report(String location, String format, String version) {
        List hostList = this.homePatchLevel.getHost();
        for (Host host : hostList) {
            List homeList = host.getHomes();
            for (Home home : homeList) {
                this.updateHomeType(home);
            }
        }
        return super.report(location, format, version);
    }

    private void updateHomeType(Home home) {
        ConfigGraph graph = PatchPlanner.getInstance().getConfigGraph();
        List<OracleHome> oracleHome = graph.getTargets(OracleHome.class);
        for (OracleHome oh : oracleHome) {
            if (!DBPatchingHelper.compareFilePath(oh.getPath(), home.getPath())) continue;
            home.setType(oh.getHomeType());
        }
    }
}

