/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency.mgmt.impl;

import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.Dependency;
import com.oracle.cie.dependency.mgmt.DependencyFileHandler;
import com.oracle.cie.dependency.mgmt.DependencyFileType;
import com.oracle.cie.dependency.mgmt.DependencyManagementException;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.LegalInformation;
import com.oracle.cie.dependency.mgmt.Module;
import com.oracle.cie.dependency.mgmt.Version;
import com.oracle.cie.dependency.mgmt.impl.ArtifactImpl;
import com.oracle.cie.dependency.mgmt.impl.DependencyImpl;
import com.oracle.cie.dependency.mgmt.impl.IvyDependencyFileHandlerImpl;
import com.oracle.cie.dependency.mgmt.impl.ModuleImpl;
import com.oracle.cie.dependency.mgmt.impl.PomDependencyFileHandlerImpl;
import com.oracle.cie.dependency.mgmt.impl.VersionImpl;
import com.oracle.cie.rest.Build;
import com.oracle.cie.rest.impl.BuildImpl;

public class DependencyManagementFactoryImpl
extends DependencyManagementFactory {
    private static DependencyFileHandler _ivyFileHandler;
    private static DependencyFileHandler _pomFileHandler;

    @Override
    public DependencyFileHandler getDependencyFileHandler(DependencyFileType type) throws DependencyManagementException {
        if (DependencyFileType.ivy == type) {
            if (_ivyFileHandler == null) {
                _ivyFileHandler = new IvyDependencyFileHandlerImpl();
            }
            return _ivyFileHandler;
        }
        if (DependencyFileType.pom == type) {
            if (_pomFileHandler == null) {
                _pomFileHandler = new PomDependencyFileHandlerImpl();
            }
            return _pomFileHandler;
        }
        throw new DependencyManagementException("Encountered unknown dependency file type " + (Object)((Object)type));
    }

    @Override
    public Module getModule(String group, String name) {
        return new ModuleImpl(group, name);
    }

    @Override
    public Module getModule(String group, String name, String version) {
        return new ModuleImpl(group, name, version);
    }

    @Override
    public Module getModule(String group, String name, String version, String type) {
        return new ModuleImpl(group, name, version, type);
    }

    @Override
    public Module getModule(String group, String name, String baseVersion, String type, String ... qualifiers) {
        return new ModuleImpl(group, name, baseVersion, type, qualifiers);
    }

    @Override
    public Module getModule(String group, String name, String baseVersion, String type, LegalInformation legalInfo, String ... qualifiers) {
        return new ModuleImpl(group, name, baseVersion, type, legalInfo, qualifiers);
    }

    @Override
    public Module getModule(String group, String name, Version version) {
        return new ModuleImpl(group, name, version);
    }

    @Override
    public Module getModule(String group, String name, Version version, String type) {
        return new ModuleImpl(group, name, version, type);
    }

    @Override
    public Module getModule(Artifact artifact, String moduleType) {
        ModuleImpl module = new ModuleImpl(artifact.getGroup(), artifact.getName(), artifact.getVersion(), artifact.getType());
        module.setModuleType(moduleType);
        return module;
    }

    @Override
    public Artifact getArtifact(String group, String name, String version) {
        return new ArtifactImpl(group, name, version);
    }

    @Override
    public Artifact getArtifact(String group, String name, String version, String type) {
        return new ArtifactImpl(group, name, version, type);
    }

    @Override
    public Artifact getArtifact(String group, String name, String baseVersion, String type, String ... qualifiers) {
        return new ArtifactImpl(group, name, baseVersion, type, qualifiers);
    }

    @Override
    public Artifact getArtifact(String group, String name, Version version) {
        return new ArtifactImpl(group, name, version);
    }

    @Override
    public Artifact getArtifact(String group, String name, Version version, String type) {
        return new ArtifactImpl(group, name, version, type);
    }

    @Override
    public Dependency getDependency(String group, String name, String version) {
        return new DependencyImpl(group, name, version);
    }

    @Override
    public Dependency getDependency(String group, String name, String version, String type) {
        return new DependencyImpl(group, name, version, type);
    }

    @Override
    public Dependency getDependency(String group, String name, String baseVersion, String type, String ... qualifiers) {
        return new DependencyImpl(group, name, baseVersion, type, qualifiers);
    }

    @Override
    public Dependency getDependency(String group, String name, Version version) {
        return new DependencyImpl(group, name, version);
    }

    @Override
    public Dependency getDependency(String group, String name, Version version, String type) {
        return new DependencyImpl(group, name, version, type);
    }

    @Override
    public Dependency getDependency(Artifact artifact) {
        return new DependencyImpl(artifact);
    }

    @Override
    public Version getVersion() {
        return new VersionImpl();
    }

    @Override
    public Version getVersion(String version) {
        return new VersionImpl(version);
    }

    @Override
    public Version getVersion(String baseVersion, String ... qualifiers) {
        return new VersionImpl(baseVersion, qualifiers);
    }

    @Override
    public Build getBuild(String buildName, String buildNumber) {
        return this.getBuild(buildName, buildNumber, null);
    }

    @Override
    public Build getBuild(String buildName, String buildNumber, String uri) {
        return new BuildImpl(buildName, buildNumber, uri);
    }
}

