/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.remote;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.util.Chmod;
import com.oracle.cie.common.util.Delete;
import com.oracle.cie.common.util.DirectoryCopy;
import com.oracle.cie.common.util.FileCopy;
import com.oracle.cie.common.util.IOUtil;
import com.oracle.cie.common.util.RuntimeExec;
import com.oracle.cie.remote.CommonConnectionHandlerImpl;
import com.oracle.cie.remote.RemoteConnectionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocalDirectoryConnectionHandlerImpl
extends CommonConnectionHandlerImpl {
    public static final String TYPE = "local-directory";
    public static final String TRANSFER_TYPE = "local-transfer";
    private boolean _prefixHost = !Boolean.getBoolean("LocalDirectoryConnectionHandlerImpl.disable.host.prefixing");

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getFileHandlerType() {
        return TRANSFER_TYPE;
    }

    public boolean isPrefixHost() {
        return this._prefixHost;
    }

    @Override
    public void connect() throws RemoteConnectionException {
        if (this.getHost() == null) {
            throw new RemoteConnectionException("The remote connection host was not set.");
        }
    }

    @Override
    public boolean isConnected() {
        return this.getHost() != null;
    }

    @Override
    public void put(String location, File sourceFile, boolean resume) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        if (sourceFile == null) {
            throw new RemoteConnectionException("The source file specified was null.");
        }
        try {
            File dest;
            File file = dest = this.isPrefixHost() ? new File(this.getHost().getHost(), location) : new File(location);
            if (sourceFile.isDirectory()) {
                DirectoryCopy.copy((File)sourceFile, (File)dest);
            } else {
                FileCopy.copy((File)sourceFile, (File)dest);
            }
        }
        catch (IOException e) {
            throw new RemoteConnectionException(e);
        }
    }

    @Override
    public void put(String location, InputStream is) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        if (is == null) {
            throw new RemoteConnectionException("The input stream specified was null.");
        }
        FileOutputStream fos = null;
        try {
            File dest = this.isPrefixHost() ? new File(this.getHost().getHost(), location) : new File(location);
            fos = new FileOutputStream(dest);
            IOUtil.copy((InputStream)is, (OutputStream)fos);
        }
        catch (IOException e) {
            throw new RemoteConnectionException(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void get(String location, OutputStream os) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        if (os == null) {
            throw new RemoteConnectionException("The output stream specified was null.");
        }
        FileInputStream fis = null;
        try {
            File sourceFile = this.isPrefixHost() ? new File(this.getHost().getHost(), location) : new File(location);
            fis = new FileInputStream(sourceFile);
            IOUtil.copy((InputStream)fis, (OutputStream)os);
        }
        catch (IOException e) {
            throw new RemoteConnectionException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void get(String location, File destination, boolean resume) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        if (destination == null) {
            throw new RemoteConnectionException("The destination specified was null.");
        }
        File sourceFile = this.isPrefixHost() ? new File(this.getHost().getHost(), location) : new File(location);
        File destFile = destination.isDirectory() ? new File(destination, sourceFile.getName()) : destination;
        try {
            FileCopy.copy((File)sourceFile, (File)destFile);
        }
        catch (IOException e) {
            throw new RemoteConnectionException("Failed to copy source file " + sourceFile + " to destination file " + destFile, e);
        }
    }

    @Override
    public void delete(String location, boolean force, boolean ignoreFailure) throws RemoteConnectionException {
        File file;
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        File file2 = file = this.isPrefixHost() ? new File(this.getHost().getHost(), location) : new File(location);
        if (file.exists() && !Delete.delete((File)file) && !ignoreFailure) {
            throw new RemoteConnectionException("Failed to delete " + file);
        }
    }

    @Override
    public boolean exists(String location) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        return (this.isPrefixHost() ? new File(this.getHost().getHost(), location) : new File(location)).exists();
    }

    @Override
    public long size(String location) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        return (this.isPrefixHost() ? new File(this.getHost().getHost(), location) : new File(location)).length();
    }

    @Override
    public boolean isDirectory(String location) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        return (this.isPrefixHost() ? new File(this.getHost().getHost(), location) : new File(location)).isDirectory();
    }

    @Override
    public void mkdir(String location) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        (this.isPrefixHost() ? new File(this.getHost().getHost(), location) : new File(location)).mkdirs();
    }

    @Override
    public void mkdirs(String location) throws RemoteConnectionException {
        this.mkdir(location);
    }

    @Override
    public void exec(String command, OutputStream output, Map<String, String> envVars) throws RemoteConnectionException {
        if (command == null || command.isEmpty()) {
            throw new RemoteConnectionException("The command specified was null or empty.");
        }
        if (output == null) {
            throw new RemoteConnectionException("The output stream specified was null.");
        }
        ArrayList<String> commands = new ArrayList<String>();
        Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(command);
        while (m.find()) {
            String s = m.group(1).replace("\"", "");
            if (this.isPrefixHost() && (s = s.replace("\\", "/")).contains("/")) {
                s = this.getHost().getHost() + s;
            }
            commands.add(s);
        }
        try {
            int result = RuntimeExec.exec(commands, envVars, null, null, (OutputStream)output, (OutputStream)output, (boolean)true);
            if (result != 0) {
                throw new RemoteConnectionException("Exec of \"" + command + "\" failed with exit code " + result);
            }
        }
        catch (IOException e) {
            throw new RemoteConnectionException(e);
        }
    }

    @Override
    public void chmod(String location, int mode) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        if (!this.isWindows()) {
            Chmod.chmod((String)(this.isPrefixHost() ? new File(this.getHost().getHost(), location) : new File(location)).getAbsolutePath(), (String)("" + mode), (boolean)false);
        }
    }

    @Override
    public boolean isWindows() throws RemoteConnectionException {
        return ComdevHelper.isWindows();
    }

    @Override
    public List<String> ls(String location) throws RemoteConnectionException {
        File directory;
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        ArrayList<String> listing = new ArrayList<String>();
        File file = directory = this.isPrefixHost() ? new File(this.getHost().getHost(), location) : new File(location);
        if (directory.isDirectory()) {
            File[] files = directory.listFiles();
            if (files != null) {
                for (File file2 : files) {
                    listing.add(file2.getName());
                }
            }
        } else {
            listing.add(directory.getName());
        }
        return listing;
    }

    @Override
    protected void closeInternal() {
    }
}

