/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.remote;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.remote.CommonSshConnectionHandlerImpl;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHost;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientProxyConnector;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.session.SessionHeartbeatController;
import org.eclipse.jgit.internal.transport.sshd.proxy.HttpClientConnector;

public class SshConnectionHandlerImpl
extends CommonSshConnectionHandlerImpl {
    @Override
    public String getType() {
        return "ssh";
    }

    @Override
    public void connect() throws RemoteConnectionException {
        if (!this.isConnected()) {
            RemoteConnectionHost hostInfo = this.getHost();
            String host = hostInfo.getHost();
            String user = hostInfo.getUsername();
            int port = hostInfo.getPort() == null ? 22 : hostInfo.getPort();
            String proxyHost = hostInfo.getProxyHost();
            int proxyPort = hostInfo.getProxyPort() == null ? 80 : hostInfo.getProxyPort();
            try {
                this._sshClient = SshClient.setUpDefaultClient();
                this._sshClient.start();
                this._clientSession = (ClientSession)((ConnectFuture)this._sshClient.connect(user, host, port).verify(7L, TimeUnit.SECONDS)).getSession();
                this._clientSession.addPasswordIdentity(new String(hostInfo.getPassword()));
                if (!StringUtil.isNullOrEmpty((String)proxyHost, (boolean)true)) {
                    InetSocketAddress proxyAddress = new InetSocketAddress(proxyHost, proxyPort);
                    InetSocketAddress remoteAddress = new InetSocketAddress(host, port);
                    HttpClientConnector proxyConnector = new HttpClientConnector(proxyAddress, remoteAddress);
                    this._clientSession.setClientProxyConnector((ClientProxyConnector)proxyConnector);
                }
                this._clientSession.setSessionHeartbeat(SessionHeartbeatController.HeartbeatType.IGNORE, TimeUnit.SECONDS, 60L);
                this._clientSession.auth().verify(11L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new RemoteConnectionException("Failed to connect to remote host " + this.getHost(), e);
            }
        }
    }
}

