/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.rest.wadl.provider;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oracle.cie.common.util.IOUtil;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.rest.FolderInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"application/vnd.org.jfrog.artifactory.storage.FolderInfo+json"})
public class StorageFolderInfo
implements MessageBodyReader<FolderInfo> {
    private static ObjectMapper mapper = new ObjectMapper();

    public boolean isReadable(Class arg, Type type, Annotation[] annotations, MediaType mediaType) {
        return "application".equalsIgnoreCase(mediaType.getType()) && "vnd.org.jfrog.artifactory.storage.FolderInfo+json".equalsIgnoreCase(mediaType.getSubtype());
    }

    public FolderInfo readFrom(Class arg, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap multivaluedMap, InputStream inputStream) throws IOException, WebApplicationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtil.bufferedCopy((InputStream)inputStream, (OutputStream)baos);
        baos.close();
        FolderInfoImpl folderInfo = (FolderInfoImpl)mapper.readValue(baos.toByteArray(), FolderInfoImpl.class);
        return folderInfo;
    }

    public static class FolderInfoImpl
    extends HashMap
    implements FolderInfo {
        private boolean _initialized = false;
        private List<String> _folderNames;
        private List<String> _fileNames;

        public static FolderInfo parse(String info) throws JsonParseException, JsonMappingException, IOException {
            FolderInfoImpl folderInfo = (FolderInfoImpl)mapper.readValue(info, FolderInfoImpl.class);
            return folderInfo;
        }

        private void init() {
            this._initialized = true;
            this._folderNames = new ArrayList<String>();
            this._fileNames = new ArrayList<String>();
            List children = (List)this.get("children");
            for (Map m : children) {
                String f = (String)m.get("uri");
                if (f.startsWith("/")) {
                    f = f.length() > 1 ? f.substring(1) : "";
                }
                if (StringUtil.isNullOrEmpty((String)f)) continue;
                boolean isFolder = (Boolean)m.get("folder");
                if (isFolder) {
                    this._folderNames.add(f);
                    continue;
                }
                this._fileNames.add(f);
            }
        }

        @Override
        public List<String> getFolders() {
            if (!this._initialized) {
                this.init();
            }
            return this._folderNames;
        }

        @Override
        public List<String> getFiles() {
            if (!this._initialized) {
                this.init();
            }
            return this._fileNames;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            ArrayList<String> allItems = new ArrayList<String>(this.getFolders());
            allItems.addAll(this.getFiles());
            if (allItems.isEmpty()) {
                buf.append("Folder is empty.");
            } else {
                buf.append("Folder contains the following [");
                for (int i = 0; i < allItems.size(); ++i) {
                    buf.append((String)allItems.get(i));
                    if (i >= allItems.size() - 1) continue;
                    buf.append(", ");
                }
                buf.append("]");
            }
            return buf.toString();
        }
    }
}

