/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard;

import com.oracle.cie.common.util.ObjectStoreManager;

public final class WizardCompletionInfo {
    private static final int DEFAULT_CANCEL_EXIT_CODE = 0;
    private static final int DEFAULT_ERROR_EXIT_CODE = 2;
    private static final int DEFAULT_FATAL_ERROR_EXIT_CODE = 1;
    private static final int DEFAULT_SUCCESS_EXIT_CODE = 0;
    private Integer _cancelCode;
    private Integer _successCode;
    private Integer _errorCode;
    private Integer _fatalCode;
    private static WizardCompletionInfo _wizardCompletionInfo;

    private WizardCompletionInfo() {
    }

    public static synchronized WizardCompletionInfo getInstance() {
        if (_wizardCompletionInfo == null) {
            _wizardCompletionInfo = new WizardCompletionInfo();
        }
        return _wizardCompletionInfo;
    }

    public int getFatalErrorCode() {
        if (this._fatalCode == null) {
            this._fatalCode = this.initialize("Wizard.return.code.fatal.error", 1);
        }
        return this._fatalCode;
    }

    public int getErrorCode() {
        if (this._errorCode == null) {
            this._errorCode = this.initialize("Wizard.return.code.error", 2);
        }
        return this._errorCode;
    }

    public int getCancelCode() {
        if (this._cancelCode == null) {
            this._cancelCode = this.initialize("Wizard.return.code.cancel", 0);
        }
        return this._cancelCode;
    }

    public int getSuccessCode() {
        if (this._successCode == null) {
            this._successCode = this.initialize("Wizard.return.code.success", 0);
        }
        return this._successCode;
    }

    private int initialize(String key, int defaultValue) {
        try {
            return Integer.parseInt(ObjectStoreManager.getObjectStore((String)"wizard-internal").getString(key));
        }
        catch (Exception ne) {
            return defaultValue;
        }
    }
}

