/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.gui.components;

import com.oracle.cie.common.ui.gui.GUIUtilities;
import com.oracle.cie.wizard.ext.progress.Phase;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class ProgressStatusTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private final Border NO_FOCUS_BORDER = new EmptyBorder(1, 7, 1, 7);
    private ImageIcon _passedStatusIcon = GUIUtilities.loadIcon((String)"resources/wizard/images/checkmark_sm_ena.png");
    private ImageIcon _failedStatusIcon = GUIUtilities.loadIcon((String)"resources/wizard/images/error_status.png");
    private ImageIcon _progressStatusIcon = GUIUtilities.loadIcon((String)"resources/wizard/images/pending_status.png");
    private ImageIcon _disableStatusIcon = GUIUtilities.loadIcon((String)"resources/wizard/images/disable_status.png");
    private Border _border = UIManager.getBorder("Table.cellNoFocusBorder");

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Object statusVal1;
        this.setBorder(this._border == null ? this.NO_FOCUS_BORDER : this._border);
        if (value instanceof Phase.Status) {
            this.setText("");
            Phase.Status status = (Phase.Status)((Object)value);
            switch (status) {
                case IN_PROGRESS: {
                    this.setIcon(this._progressStatusIcon);
                    break;
                }
                case PASSED: {
                    this.setIcon(this._passedStatusIcon);
                    break;
                }
                case FAILED: {
                    this.setIcon(this._failedStatusIcon);
                    break;
                }
                case DISABLED: {
                    this.setIcon(this._disableStatusIcon);
                    break;
                }
                default: {
                    this.setIcon(null);
                    this.setText("");
                }
            }
            this.setHorizontalAlignment(0);
        }
        if (value instanceof String) {
            this.setIcon(null);
            this.setText((String)value);
            Object statusVal = table.getValueAt(row, 0);
            if (statusVal instanceof Phase.Status && Phase.Status.DISABLED.equals((Object)((Phase.Status)((Object)statusVal)))) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            this.setHorizontalAlignment(2);
        }
        if (column == 0 && (statusVal1 = table.getValueAt(row, 0)) instanceof Phase.Status) {
            this.getAccessibleContext().setAccessibleName(String.valueOf(table.getValueAt(row, 1)) + String.valueOf(table.getValueAt(row, 0)));
        }
        if (column == 1) {
            this.getAccessibleContext().setAccessibleName((String)table.getValueAt(row, column));
        }
        return this;
    }
}

