/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.engine;

import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.cie.wizard.ConfigurationOption;
import com.oracle.cie.wizard.WizardConfigurationLoader;
import com.oracle.cie.wizard.conf.OptionErrorHolder;
import com.oracle.cie.wizard.conf.WizardOptionsHandler;
import com.oracle.cie.wizard.helpers.CommandLineHolder;
import com.oracle.cie.wizard.helpers.CommandLineParser;
import com.oracle.cie.wizard.internal.engine.CoreOptionsHandler;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Stack;

public class DefaultWizardConfiguration
implements WizardConfigurationLoader {
    protected List<WizardOptionsHandler> _handlers;
    protected Map<String, ConfigurationOption> _combinedOptions;
    protected Map<String, String> _options;
    protected List<String> _arguments;
    protected List<OptionErrorHolder> _errors = new ArrayList<OptionErrorHolder>();
    protected List<OptionErrorHolder> _warnings = new ArrayList<OptionErrorHolder>();
    private List<String> _unrecognized = new ArrayList<String>();
    private boolean _isUsageRequested;

    public DefaultWizardConfiguration() {
        this._handlers = new ArrayList<WizardOptionsHandler>();
        this._combinedOptions = new LinkedHashMap<String, ConfigurationOption>();
        this._combinedOptions.put(HELP.getName(), HELP);
        this._combinedOptions.put(ARGS_FILE.getName(), ARGS_FILE);
        this.addOptionsHandler(new CoreOptionsHandler());
        Stack<WizardOptionsHandler> extraHandlers = new Stack<WizardOptionsHandler>();
        try {
            ServiceLoader<WizardOptionsHandler> loader = ServiceLoader.load(WizardOptionsHandler.class, DefaultWizardConfiguration.class.getClassLoader());
            for (WizardOptionsHandler v : loader) {
                extraHandlers.push(v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (!extraHandlers.isEmpty()) {
            this.addOptionsHandler((WizardOptionsHandler)extraHandlers.pop());
        }
    }

    public void addOptionsHandler(WizardOptionsHandler extension) {
        for (String name : extension.getHiddenOptions()) {
            if (HELP.getName().equals(name) || ARGS_FILE.getName().equals(name)) continue;
            this._combinedOptions.remove(name);
        }
        for (ConfigurationOption option : extension.getSupportedOptions()) {
            this._combinedOptions.put(option.getName(), option);
        }
        this._handlers.add(0, extension);
    }

    @Override
    public void setCommandLineArguments(String[] args) throws IllegalStateException {
        if (args.length == 1 && (args[0].equalsIgnoreCase("-h") || args[0].equals("--help"))) {
            this._isUsageRequested = true;
        }
        CommandLineHolder clh = this.parseCommandLineArgs(args);
        this.init(clh.getOptions(), clh.getArguments(), clh.getUnattachedValues());
    }

    @Override
    public void setOptions(Map<String, String> options) throws IllegalStateException {
        this.setOptions(options, null);
    }

    @Override
    public void setOptions(Map<String, String> options, List<String> arguments) throws IllegalStateException {
        this.init(options, arguments, null);
    }

    @Override
    public boolean isValid() {
        return this._options != null && this.getErrors().isEmpty();
    }

    @Override
    public List<String> getErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        for (OptionErrorHolder err : this._errors) {
            errors.add(this.getL10NString(err.getKey(), err.getDefaultValue(), err.getParams()));
        }
        return errors;
    }

    @Override
    public List<String> getWarnings() {
        ArrayList<String> warnings = new ArrayList<String>();
        for (OptionErrorHolder err : this._warnings) {
            warnings.add(this.getL10NString(err.getKey(), err.getDefaultValue(), err.getParams()));
        }
        return warnings;
    }

    @Override
    public String getAllErrors() {
        StringBuilder sb = new StringBuilder();
        for (String error : this.getErrors()) {
            if (sb.length() > 0) {
                sb.append(System.getProperty("line.separator"));
            }
            sb.append(error);
        }
        return sb.toString();
    }

    @Override
    public List<String> getUnrecognized() {
        return Collections.unmodifiableList(this._unrecognized);
    }

    @Override
    public boolean isUsageRequested() {
        return this._isUsageRequested;
    }

    @Override
    public String getUsage() {
        return this.getUsage(this._combinedOptions);
    }

    protected String getUsage(Map<String, ConfigurationOption> options) {
        StringBuilder sb = new StringBuilder(700);
        sb.append(this.getL10NString("wizard.conf.usage.title", "Wizard options. Required options are marked with \"*\":", new String[0])).append(System.getProperty("line.separator"));
        int maxLen = 0;
        for (String name : options.keySet()) {
            maxLen = Math.max(maxLen, name.length());
        }
        for (ConfigurationOption option : options.values()) {
            StringBuilder values = new StringBuilder();
            if (option.getAllowedValues() != null) {
                for (String v : option.getAllowedValues()) {
                    if (values.length() > 0) {
                        values.append(", ");
                    }
                    values.append(v);
                }
            }
            String descr = MessageFormat.format(option.getDescr(), values, option.getDefaultValue());
            sb.append(String.format("%" + (5 + maxLen) + "s%s - %s%n", "-" + option.getName(), option.isRequired() ? "*" : "", descr));
        }
        return sb.toString();
    }

    @Override
    public Map<String, String> getOptions() {
        if (this._options == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this._options);
    }

    @Override
    public String getOptionValue(ConfigurationOption option) {
        return option == null ? null : this.getOptionValue(option.getName());
    }

    @Override
    public String getOptionValue(String option) {
        return this._options == null ? null : this._options.get(option);
    }

    @Override
    public boolean isOptionSet(ConfigurationOption option) {
        return option == null ? null : Boolean.valueOf(this.isOptionSet(option.getName()));
    }

    @Override
    public boolean isOptionSet(String option) {
        return this._options == null ? null : Boolean.valueOf(this._options.containsKey(option));
    }

    @Override
    public List<String> getArguments() {
        return this._arguments;
    }

    private CommandLineHolder parseCommandLineArgs(String[] args) {
        return new CommandLineParser().parseCommandLineArgs(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> loadOptionsFromFile(String filename) {
        Properties p = new Properties();
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(filename);
            if (is != null) {
                p.load(is);
            }
        }
        catch (IOException iox) {
            this._errors.add(new OptionErrorHolder("wizard.conf.errors.invalidfile", "Unable to retrieve arguments from \"{0}\": {1}", filename, iox.getLocalizedMessage()));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new HashMap<Object, Object>(p);
    }

    private synchronized void init(Map<String, String> options, List<String> arguments, List<String> unattachedValues) throws IllegalStateException {
        if (this._options != null) {
            this._errors.add(new OptionErrorHolder("wizard.conf.errors.initialized", "Wizard configuration has been initialized already.", new String[0]));
            throw new IllegalStateException("Wizard configuration has been initialized already.");
        }
        this._options = new LinkedHashMap<String, String>();
        this._unrecognized = new ArrayList<String>();
        if (options != null) {
            if (options.containsKey(ARGS_FILE.getName())) {
                this._options.putAll(this.loadOptionsFromFile(this._options.remove(ARGS_FILE.getName())));
            }
            this._options.putAll(options);
        }
        if (this._options.containsKey(HELP.getName())) {
            this._isUsageRequested = true;
            this._options.remove(HELP.getName());
        }
        this._unrecognized.addAll(this._options.keySet());
        for (WizardOptionsHandler handler : this._handlers) {
            handler.setOptionValues(this._options);
            this._unrecognized.removeAll(handler.getHandledOptions());
            for (String handled : handler.getHandledOptions()) {
                this._options.remove(handled);
            }
            this._options.putAll(handler.getProcessedOptions());
            this._errors.addAll(handler.getErrors());
            this._warnings.addAll(handler.getWarnings());
        }
        this._arguments = new ArrayList<String>();
        if (arguments != null) {
            this._arguments.addAll(arguments);
        }
        if (unattachedValues != null) {
            for (String value : unattachedValues) {
                this._errors.add(new OptionErrorHolder("wizard.conf.errors.unattached.value", "Value \"{0}\" is not associated with any option.", value));
            }
        }
    }

    protected String getL10NString(String key, String defaultValue, String ... params) {
        String pattern = ResourceBundleManager.getString((String)"wizard-internal", (String)key);
        if (pattern == null) {
            pattern = defaultValue;
        }
        if (pattern != null && params != null && params.length > 0) {
            return MessageFormat.format(pattern, params);
        }
        return pattern;
    }
}

