/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.wcf;

import com.oracle.cie.wizard.internal.wcf.EntryElem;
import com.oracle.cie.wizard.internal.wcf.EntryElemFactory;
import com.oracle.cie.wizard.internal.wcf.SubflowEndMarker;
import com.oracle.cie.wizard.internal.wcf.Target;
import com.oracle.cie.wizard.internal.wcf.WCFElement;
import com.oracle.cie.wizard.internal.wcf.WCFWorkflow;
import com.oracle.cie.wizard.internal.wcf.xml.EntrySequenceType;
import com.oracle.cie.wizard.internal.wcf.xml.EntryType;
import com.oracle.cie.wizard.wcf.ExecPlanException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class Subflow<E extends EntrySequenceType>
extends WCFElement {
    protected E _xmlSequence;
    protected List<EntryElem<?>> _entries = new ArrayList();
    protected SubflowEndMarker<E> _endOfSequence;

    protected Subflow(WCFWorkflow flow, E sequence) throws ExecPlanException {
        super(flow);
        this._xmlSequence = sequence;
        this._endOfSequence = new SubflowEndMarker(this);
    }

    public E getXmlSequence() {
        return this._xmlSequence;
    }

    public List<EntryElem<?>> getEntries() {
        return Collections.unmodifiableList(this._entries);
    }

    @Override
    public List<WCFElement> getDefaultElementList() throws ExecPlanException {
        ArrayList<WCFElement> list = new ArrayList<WCFElement>();
        list.add(this);
        for (EntryElem<?> entry : this.getEntries()) {
            list.addAll(entry.getDefaultElementList());
        }
        list.add(this._endOfSequence);
        return list;
    }

    public SubflowEndMarker<E> getEndOfSequence() {
        return this._endOfSequence;
    }

    abstract Target getTarget();

    abstract EntryElem<?> getParentEntryElem();

    protected void loadEntries() throws ExecPlanException {
        for (EntryType entry : ((EntrySequenceType)this._xmlSequence).getEntries()) {
            this._entries.add(EntryElemFactory.getFactory().createEntry(this, entry));
        }
    }
}

