/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.wcf;

import com.oracle.cie.wizard.internal.wcf.xml.TaskPropertyType;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.wcf.TaskProperty;
import java.util.ArrayList;
import java.util.List;

class TaskPropertyWrapper
implements TaskProperty {
    private TaskPropertyType _xmlPeer;

    public TaskPropertyWrapper(TaskPropertyType xmlPeer) {
        if (xmlPeer == null) {
            throw new IllegalArgumentException("Task definition cannot be null!");
        }
        this._xmlPeer = xmlPeer;
    }

    @Override
    public String getName() {
        return this._xmlPeer.getName();
    }

    @Override
    public boolean isRequired() {
        return this._xmlPeer.isRequired();
    }

    @Override
    public String getDefaultValue() {
        return this._xmlPeer.getDefaultValue();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("[").append(super.toString());
        sb.append(" typeConstraints='").append(this.getTypeConstraints()).append("'");
        sb.append(" name='").append(this.getName()).append("'");
        sb.append(" required='").append(this.isRequired()).append("'");
        sb.append(" type='").append((Object)this.getType()).append("'");
        sb.append(" default='").append(this.getDefaultValue()).append("'");
        sb.append("]");
        return sb.toString();
    }

    @Override
    public TaskAttributeType getType() {
        if (this._xmlPeer.getType() == null) {
            return TaskAttributeType.LITERAL;
        }
        switch (this._xmlPeer.getType()) {
            case LITERAL: {
                return TaskAttributeType.LITERAL;
            }
            case BOOLEAN: {
                return TaskAttributeType.BOOLEAN;
            }
            case ENUM: {
                return TaskAttributeType.ENUM;
            }
            case CLASS: {
                return TaskAttributeType.CLASS;
            }
            case RESOURCE: {
                return TaskAttributeType.RESOURCE;
            }
            case OBJECT_STORE_KEY: {
                return TaskAttributeType.OBJECT_STORE_KEY;
            }
            case RESOURCE_KEY: {
                return TaskAttributeType.RESOURCE_KEY;
            }
        }
        return TaskAttributeType.LITERAL;
    }

    @Override
    public List<String> getTypeConstraints() {
        ArrayList<String> tCList = new ArrayList<String>();
        for (int i = 0; i < this._xmlPeer.getTypeConstraints().size(); ++i) {
            tCList.add(this._xmlPeer.getTypeConstraints().get(i).getValue());
        }
        return tCList;
    }
}

