/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.wcf;

import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.cie.wizard.WizardConfiguration;
import com.oracle.cie.wizard.internal.engine.DefaultWizardConfiguration;
import com.oracle.cie.wizard.internal.engine.WizardTaskFactory;
import com.oracle.cie.wizard.internal.wcf.EntryElem;
import com.oracle.cie.wizard.internal.wcf.LoopElem;
import com.oracle.cie.wizard.internal.wcf.SwitchElem;
import com.oracle.cie.wizard.internal.wcf.Target;
import com.oracle.cie.wizard.internal.wcf.TaskDefinitionWrapper;
import com.oracle.cie.wizard.internal.wcf.TaskEntryElem;
import com.oracle.cie.wizard.internal.wcf.WCFWorkflow;
import com.oracle.cie.wizard.internal.wcf.WCFWrapper;
import com.oracle.cie.wizard.internal.wcf.xml.SwitchType;
import com.oracle.cie.wizard.internal.wcf.xml.TargetType;
import com.oracle.cie.wizard.tasks.InvalidTaskException;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskFactory;
import com.oracle.cie.wizard.wcf.ExecPlanException;
import com.oracle.cie.wizard.wcf.TaskDefinition;
import com.oracle.cie.wizard.wcf.TaskEntry;
import com.oracle.cie.wizard.wcf.TaskProperty;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;

public class WCFVerifier {
    public static Writer s_logWriter = new PrintWriter(System.err, true);
    public static final int VERIFICATION_FAILED = -4;

    public static boolean verifyWCF(String wcfName) throws ExecPlanException {
        return WCFVerifier.verifyWCFTarget(wcfName, null);
    }

    public static boolean verifyWCFTarget(String wcfName, String targetName) throws ExecPlanException {
        WizardTaskFactory factory = new WizardTaskFactory();
        factory.setTaskClazzLoader(WCFVerifier.class.getClassLoader());
        StringBuilder sb = new StringBuilder("#### Verifying WCF [");
        sb.append(wcfName).append("]  Target [");
        if (targetName == null) {
            sb.append("All");
        } else {
            sb.append(targetName);
        }
        sb.append("]...");
        WCFVerifier.log(sb.toString() + "\n");
        boolean success = true;
        WCFWorkflow tw = new WCFWorkflow();
        WCFFileValidationEventHandler wcfFileValidationEH = new WCFFileValidationEventHandler();
        tw.init(null, wcfName, targetName, WCFVerifier.class.getClassLoader(), wcfFileValidationEH);
        Set<String> wcfProblemSet = wcfFileValidationEH.getWcfProblems();
        StringBuilder wcfStringBuilder = new StringBuilder("## Verifying WCF File [" + wcfName + "]...");
        WCFVerifier.log("\t* " + wcfStringBuilder);
        if (wcfProblemSet.isEmpty()) {
            WCFVerifier.log("SUCCESS!\n");
        } else {
            success = false;
            WCFVerifier.log("FAILURE!\n");
            for (String wcfProblem : wcfProblemSet) {
                WCFVerifier.log("\t* " + wcfProblem + "\n");
            }
        }
        for (WCFWrapper wcfWrapper : tw.getLoadedWCFs()) {
            WCFVerifier.log("### Verifying WCF [" + wcfWrapper.getWcFileName() + "]...\n");
            Map<String, TaskDefinitionWrapper> taskDefMap = wcfWrapper.getTaskDefinitionMap();
            for (TaskDefinition taskDefinition : taskDefMap.values()) {
                if (WCFVerifier.verifyTaskVsDefinition(factory, taskDefinition)) continue;
                success = false;
            }
            ArrayList<Target> targets = new ArrayList<Target>();
            if (targetName == null) {
                for (TargetType t : wcfWrapper.getWCFile().getTargets()) {
                    targets.add(wcfWrapper.createTargetWrapper(t.getName()));
                }
            } else if (wcfName.equals(wcfWrapper.getWcFileName())) {
                targets.add(wcfWrapper.createTargetWrapper(targetName));
            }
            for (Target target : targets) {
                if (WCFVerifier.verifyTarget(factory, target)) continue;
                success = false;
            }
            WCFVerifier.log("### Finished Verifying WCF [" + wcfWrapper.getWcFileName() + "]...\n");
        }
        WCFVerifier.log(sb.append(success ? "SUCCESS!" : "FAILURE!").append("\n\n").toString());
        return success;
    }

    private static boolean verifyTarget(WizardTaskFactory factory, Target target) {
        WCFVerifier.log("## Verifying Target [" + target.getName() + "]...");
        List<String> problems = WCFVerifier.verifyEntryElements(factory, target.getEntries());
        if (problems.isEmpty()) {
            WCFVerifier.log("SUCCESS!\n");
        } else {
            WCFVerifier.log("FAILURE:\n");
            for (String problem : problems) {
                WCFVerifier.log("\t\t* " + problem + "\n");
            }
        }
        return problems.isEmpty();
    }

    private static List<String> verifyEntryElements(WizardTaskFactory factory, List<EntryElem<?>> entries) {
        ArrayList<String> problems = new ArrayList<String>();
        for (EntryElem<?> entry : entries) {
            if (TaskEntryElem.class.isAssignableFrom(entry.getClass())) {
                problems.addAll(WCFVerifier.verifyTaskEntry(factory, (TaskEntryElem)entry));
                continue;
            }
            if (SwitchElem.class.isAssignableFrom(entry.getClass())) {
                String defaultBranchName = ((SwitchElem)entry).getDefaultBranchName();
                if (defaultBranchName != null) {
                    boolean defaultBranchExist = false;
                    for (String branchKeyinSwitch : ((SwitchElem)entry).getBranchKeys()) {
                        if (!branchKeyinSwitch.equals(defaultBranchName)) continue;
                        defaultBranchExist = true;
                        break;
                    }
                    if (!defaultBranchExist) {
                        problems.add("Switch block [" + ((SwitchType)((SwitchElem)entry).getXmlObject()).getProperty() + "] has invalid default branch:" + defaultBranchName);
                    }
                }
                for (String branchKeyinSwitch : ((SwitchElem)entry).getBranchKeys()) {
                    problems.addAll(WCFVerifier.verifyEntryElements(factory, ((SwitchElem)entry).getBranchEntries(branchKeyinSwitch)));
                }
                continue;
            }
            if (!LoopElem.class.isAssignableFrom(entry.getClass())) continue;
            problems.addAll(WCFVerifier.verifyEntryElements(factory, ((LoopElem)entry).getLoopBody().getEntries()));
        }
        return problems;
    }

    private static List<String> verifyTaskEntry(WizardTaskFactory factory, TaskEntryElem entry) {
        ArrayList<String> problems = new ArrayList<String>();
        TaskDefinition taskDef = entry.getTaskDefinition();
        if (taskDef == null) {
            problems.add(entry.getName() + " has no corresponding task definition.");
            return problems;
        }
        problems.addAll(WCFVerifier.verifyTaskEntryVsTaskDef(entry, taskDef));
        try {
            factory.configureTask(factory.createTask(taskDef), entry);
        }
        catch (InvalidTaskException e) {
            problems.add(entry.getName() + ": " + e);
        }
        return problems;
    }

    private static List<String> verifyTaskEntryVsTaskDef(TaskEntry entry, TaskDefinition taskDef) {
        ArrayList<String> problems = new ArrayList<String>();
        String taskName = entry.getName();
        ArrayList<String> defProps = new ArrayList<String>(taskDef.getPropertyNames());
        Set<String> taskAttrs = entry.getAttributeMap().keySet();
        ArrayList<String> definedTaskAttrs = new ArrayList<String>();
        for (String attr : taskAttrs) {
            if (!defProps.remove(attr)) {
                problems.add(taskName + ": Property [\"" + attr + "\"] is not defined in the task definition.");
                continue;
            }
            definedTaskAttrs.add(attr);
        }
        for (String prop : defProps) {
            if (!taskDef.getProperty(prop).isRequired()) continue;
            problems.add(taskName + ": Required property [\"" + prop + "\"] is not set.");
        }
        block14: for (String defTaskAttr : definedTaskAttrs) {
            switch (taskDef.getProperty(defTaskAttr).getType()) {
                case BOOLEAN: {
                    if (Boolean.TRUE.toString().equalsIgnoreCase(entry.getAttributeMap().get(defTaskAttr)) || Boolean.FALSE.toString().equalsIgnoreCase(entry.getAttributeMap().get(defTaskAttr))) break;
                    problems.add(" Property [" + entry.getAttributeMap().get(defTaskAttr) + "] can have only BOOLEAN values. \n");
                    break;
                }
                case LITERAL: 
                case OBJECT_STORE_KEY: {
                    break;
                }
                case CLASS: {
                    try {
                        List<String> klass = taskDef.getProperty(defTaskAttr).getTypeConstraints();
                        Class<?> clazz = Class.forName(entry.getAttributeMap().get(defTaskAttr));
                        for (String klassName : klass) {
                            if (Class.forName(klassName).isAssignableFrom(clazz)) continue;
                            problems.add("Class: \"" + clazz.getName() + "\" does not extends the SuperClass/Interface provided in the task definition: \"" + klass + "\"");
                        }
                        continue block14;
                    }
                    catch (ClassNotFoundException e) {
                        problems.add("Class: \"" + entry.getAttributeMap().get(defTaskAttr) + "\" is not present in the classpath.");
                        break;
                    }
                }
                case RESOURCE: {
                    String val = entry.getAttributeMap().get(defTaskAttr);
                    if (WCFVerifier.class.getClassLoader().getResource(val) != null) break;
                    problems.add("Resource: \"" + entry.getAttributeMap().get(defTaskAttr) + "\" is not present in the classpath.");
                    break;
                }
                case ENUM: {
                    if (!taskDef.getProperty(defTaskAttr).getTypeConstraints().isEmpty()) {
                        if (entry.getAttributeMap().get(defTaskAttr) == null) {
                            problems.add("Enumerated Value for Task Property: \"" + defTaskAttr + "\" is left blank.");
                            break;
                        }
                        if (taskDef.getProperty(defTaskAttr).getTypeConstraints().contains(entry.getAttributeMap().get(defTaskAttr))) break;
                        problems.add("Enumerated Value: \"" + entry.getAttributeMap().get(defTaskAttr) + "\" does not match any of the values which are defined in the Task Definition. \n");
                        break;
                    }
                    problems.add("Enumerated Values for Task Property: \"" + defTaskAttr + "\" needs to be defined explicitly in Task Definition: " + taskDef.getName() + " and can not be left EMPTY. \n");
                    break;
                }
                case RESOURCE_KEY: {
                    try {
                        String str = ResourceBundleManager.getString((String)entry.getNamespace(), (String)entry.getAttributeMap().get(defTaskAttr));
                        if (str != null && !str.isEmpty()) continue block14;
                        problems.add("Resource Key: \"" + entry.getAttributeMap().get(defTaskAttr) + "\" does not match any of the resource keys defined in the Task Definition. \n");
                        break;
                    }
                    catch (MissingResourceException mre) {
                        problems.add("MissingResourceException: " + mre + "\n");
                    }
                }
            }
        }
        return problems;
    }

    private static boolean verifyTaskVsDefinition(TaskFactory factory, TaskDefinition taskDef) {
        if (taskDef == null) {
            throw new IllegalArgumentException("Task definition must be non-null!");
        }
        String taskName = taskDef.getName();
        WCFVerifier.log("# Verifying Task Definition [" + taskName + "] class [" + taskDef.getClassName() + "] ... ");
        ArrayList<String> problems = new ArrayList<String>();
        try {
            String clazzName = taskDef.getClassName();
            Class<?> clazz = WCFVerifier.class.getClassLoader().loadClass(clazzName);
            TaskDescription taskDescr = clazz.getAnnotation(TaskDescription.class);
            if (taskDescr == null) {
                problems.add("Class does not define " + TaskDescription.class.getName() + " annotation.");
            } else {
                if (!"_UNSET_".equals(taskDescr.name()) && !taskDescr.name().equals(taskDef.getName())) {
                    problems.add("name in " + TaskDescription.class.getSimpleName() + " does not match task definition.");
                }
                if (taskDescr.cachingPolicy() != taskDef.getCachingPolicy()) {
                    problems.add("caching-policy in " + TaskDescription.class.getSimpleName() + " does not match task definition.");
                }
            }
            problems.addAll(WCFVerifier.verifyProperties(taskDef, clazz));
            factory.createTask(taskDef);
        }
        catch (ClassNotFoundException e) {
            problems.add(e.getMessage());
        }
        catch (InvalidTaskException e) {
            problems.add("Unable to instantiate task: " + e);
        }
        catch (Exception x) {
            problems.add("Unable to verify task: " + x);
        }
        if (problems.isEmpty()) {
            WCFVerifier.log("SUCCESS!\n");
        } else {
            WCFVerifier.log("FAILURE:\n");
            for (String problem : problems) {
                WCFVerifier.log("\t\t* " + problem + "\n");
            }
        }
        return problems.isEmpty();
    }

    private static List<String> verifyProperties(TaskDefinition taskDef, Class<?> clazz) {
        ArrayList<String> problems = new ArrayList<String>();
        LinkedHashMap<String, Object> setters = new LinkedHashMap<String, Object>();
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            for (Method method : c.getDeclaredMethods()) {
                int mods = method.getModifiers();
                Class<?>[] paramTypes = method.getParameterTypes();
                if ((mods & 1) != 0 && (mods & 8) == 0 && method.getName().startsWith("set") && method.getReturnType() == Void.TYPE && paramTypes.length == 1 && paramTypes[0] == String.class) {
                    setters.put(method.getName(), method);
                    continue;
                }
                if (method.getAnnotation(TaskAttribute.class) == null) continue;
                problems.add(TaskAttribute.class.getSimpleName() + " is set on invalid method [" + method + "]. The singnature must be: public void setXXX(String v)");
            }
        }
        for (String propName : taskDef.getPropertyNames()) {
            String tAttrDflt;
            String methodName = "set" + Character.toUpperCase(propName.charAt(0)) + propName.substring(1);
            Method method = (Method)setters.remove(methodName);
            if (method == null) {
                problems.add("Class has no setter method for property [" + propName + "]");
                continue;
            }
            TaskAttribute taskAttr = method.getAnnotation(TaskAttribute.class);
            if (taskAttr == null) {
                problems.add(method.getName() + " method doesn't have " + TaskAttribute.class.getSimpleName() + " annotation.");
                continue;
            }
            TaskProperty prop = taskDef.getProperty(propName);
            if (taskAttr.required() != prop.isRequired()) {
                problems.add("[" + propName + "] property \"required\" attribute doesn't match " + TaskAttribute.class.getSimpleName());
            }
            if ((tAttrDflt = taskAttr.defaultValue()).equals("__UNSET__")) {
                tAttrDflt = null;
            }
            String propDflt = prop.getDefaultValue();
            if (tAttrDflt == null && propDflt != null || tAttrDflt != null && !tAttrDflt.equals(propDflt)) {
                problems.add("[" + propName + "] property \"defaultValue\" attribute doesn't match " + TaskAttribute.class.getSimpleName() + ". " + propName + " property has default value as: " + propDflt + " and Task Attribute " + TaskAttribute.class.getSimpleName() + "has default value as: " + tAttrDflt);
            }
            if (taskAttr.type() != prop.getType()) {
                problems.add("[" + propName + "] property \"Type\" attribute doesn't match Type of " + TaskAttribute.class.getSimpleName() + " annotation. \nProperty: " + propName + " has Attribute Type: " + prop.getType().name() + " and " + TaskAttribute.class.getSimpleName() + " annotation has Attribute Type: " + taskAttr.type().name());
                continue;
            }
            WCFVerifier.verifyTypeConstraints(prop, taskAttr, propName, problems);
            switch (prop.getType()) {
                case BOOLEAN: 
                case LITERAL: 
                case OBJECT_STORE_KEY: 
                case RESOURCE: 
                case RESOURCE_KEY: {
                    if (prop.getTypeConstraints().isEmpty()) break;
                    problems.add(" Property [" + propName + "] has \"Type\": \"" + (Object)((Object)prop.getType()) + "\" . It  can not be restricted with any constraint. \n");
                    break;
                }
                case ENUM: {
                    if (!prop.getTypeConstraints().isEmpty()) break;
                    problems.add(" Property [" + propName + "] has \"Type\": \"" + (Object)((Object)prop.getType()) + "\" . It has \"EMPTY\" TypeConstraints List.\n");
                    break;
                }
                case CLASS: {
                    if (prop.getTypeConstraints().isEmpty()) break;
                    for (String propTypeConstraints : prop.getTypeConstraints()) {
                        try {
                            Class<?> clazzname = Class.forName(propTypeConstraints);
                            if (Modifier.isPrivate(clazzname.getModifiers())) {
                                problems.add(" \"Type Constraint\" for [" + propName + "] property is a Class one of the Class Modifiers as PRIVATE. The Class is: \"" + clazzname + "\" Classes should not have any of the modifier as PRIVATE if it is used as a Type Contraint.");
                            }
                            if (!Modifier.isFinal(clazzname.getModifiers())) continue;
                            problems.add(" \"Type Constraint\" for [" + propName + "] property is a Class whose one of the Class Modifier is FINAL. The Class Name is: \"" + clazzname + "\" Classes should not have any of the modifier as FINAL if it is to be used as a Type Contraint.");
                        }
                        catch (ClassNotFoundException e) {
                            problems.add(" \"Type Constraint\" for [" + propName + "] property is a Class: \"" + propTypeConstraints + "\" which is not present in the classpath.");
                        }
                    }
                    break;
                }
            }
        }
        for (String methodName : ((HashMap)setters).keySet()) {
            problems.add("Found public mutator not defined in task definition: " + methodName);
        }
        return problems;
    }

    private static void verifyTypeConstraints(TaskProperty prop, TaskAttribute taskAttr, String propName, List<String> problems) {
        ArrayList<String> typeConstraintsList = new ArrayList<String>(Arrays.asList(taskAttr.typeConstraints()));
        ArrayList<String> matchingTypeContraints = new ArrayList<String>();
        ArrayList<String> extraPropTypeContraints = new ArrayList<String>();
        ArrayList<String> duplicatePropTypeContraints = new ArrayList<String>();
        HashSet<String> uniqueTypeConstraints = new HashSet<String>();
        for (String propTypeConstraints : prop.getTypeConstraints()) {
            if (!uniqueTypeConstraints.add(propTypeConstraints)) {
                duplicatePropTypeContraints.add(propTypeConstraints);
                continue;
            }
            int propIndex = typeConstraintsList.indexOf(propTypeConstraints);
            if (propIndex > -1) {
                matchingTypeContraints.add(propTypeConstraints);
                continue;
            }
            extraPropTypeContraints.add(propTypeConstraints);
        }
        typeConstraintsList.removeAll(matchingTypeContraints);
        if (!(typeConstraintsList.isEmpty() && extraPropTypeContraints.isEmpty() && duplicatePropTypeContraints.isEmpty())) {
            problems.add("[" + propName + "] property \"Type Constraints\" does not match with that of " + TaskAttribute.class.getSimpleName() + ". \n \"MisMatching Type Constraints\" for [" + propName + "] are:  " + typeConstraintsList + ". \n \"Extra Type Constraints\" for [" + propName + "] are:  " + extraPropTypeContraints + ". \n \"Duplicate Type Constraints\" for [" + propName + "] are:  " + duplicatePropTypeContraints + ". \n");
        }
    }

    private static void log(String msg) {
        try {
            s_logWriter.write(msg);
            s_logWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getUsageInfo() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("WCFVerifier Options:\n");
        sb.append("\t");
        sb.append(WizardConfiguration.CTRLFILE);
        sb.append("=<filename>\tWizard control file.\n");
        sb.append("\t");
        sb.append(WizardConfiguration.TARGET);
        sb.append("=<target>\tThe target to use.\n");
        sb.append("\t");
        sb.append(WizardConfiguration.LOGFILE);
        sb.append("=<filename>\t\tverification log file.\n");
        sb.append("\t");
        return sb.toString();
    }

    public static void main(String[] args) {
        String filename;
        DefaultWizardConfiguration conf = new DefaultWizardConfiguration();
        conf.setCommandLineArguments(args);
        if (conf.isUsageRequested()) {
            System.out.println(WCFVerifier.getUsageInfo());
            System.exit(-1);
        }
        if ((filename = conf.getOptionValue(WizardConfiguration.CTRLFILE)) == null) {
            System.out.println("You must supply a WCF filename!");
            System.exit(-2);
        }
        try {
            String logFile = conf.getOptionValue(WizardConfiguration.LOGFILE);
            if (logFile != null) {
                s_logWriter = new FileWriter(logFile);
            }
        }
        catch (IOException logFile) {
            // empty catch block
        }
        try {
            if (!WCFVerifier.verifyWCFTarget(filename, conf.getOptionValue(WizardConfiguration.TARGET))) {
                System.exit(-4);
            }
        }
        catch (ExecPlanException wdx) {
            wdx.printStackTrace();
            System.exit(-3);
        }
    }

    protected static class WCFFileValidationEventHandler
    implements ValidationEventHandler {
        Set<String> wcfProblemSet = new HashSet<String>();

        protected WCFFileValidationEventHandler() {
        }

        public boolean handleEvent(ValidationEvent ve) {
            ValidationEventLocator vel = ve.getLocator();
            String wcfMsg = "[" + vel.getURL() + " - line:" + vel.getLineNumber() + ", column:" + vel.getColumnNumber() + "] " + ve.getMessage();
            switch (ve.getSeverity()) {
                case 1: 
                case 2: {
                    this.wcfProblemSet.add(wcfMsg);
                    break;
                }
            }
            return true;
        }

        public Set<String> getWcfProblems() {
            return this.wcfProblemSet;
        }
    }
}

