/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.silent.tasks;

import com.oracle.cie.wizard.silent.tasks.AbstractSetSilentTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskCachingPolicy;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.io.File;

@TaskDescription(name="exists", cachingPolicy=TaskCachingPolicy.REUSE)
public class FileExistsTask
extends AbstractSetSilentTask {
    private String _file;

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=true)
    public void setFile(String file) {
        this._file = file;
    }

    @Override
    public void execute() throws TaskExecutionException {
        File f = null;
        boolean result = false;
        if (this._file != null && this._file.length() > 0) {
            f = new File(this._context.substitute(this._namespace, this._file));
            result = f.exists();
        }
        this.setKeyOnTarget(String.valueOf(result));
        this._logger.finer("File \"" + f + "\" exists=" + result);
    }

    @Override
    public void unconfigure() {
        super.unconfigure();
        this._file = null;
    }
}

