/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.silent.tasks;

import com.oracle.cie.common.util.ObjectStoreManager;
import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.wizard.silent.tasks.AbstractSilentTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskCachingPolicy;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.util.logging.Level;

@TaskDescription(name="set_message_prefix", cachingPolicy=TaskCachingPolicy.REUSE)
public class SetMessagePrefixTask
extends AbstractSilentTask {
    private String _prefix;
    private static final String MESSAGE_PREFIX_KEY = "operation.message.prefix.text";

    @TaskAttribute(type=TaskAttributeType.LITERAL)
    public void setPrefix(String prefix) {
        this._prefix = prefix;
    }

    @Override
    public void execute() throws TaskExecutionException {
        boolean prefixSet = false;
        if (this._prefix != null) {
            try {
                ResourceBundleManager.setPrefix((String)this._namespace, (String)this._prefix);
                prefixSet = true;
            }
            catch (IllegalArgumentException iae) {
                this._logger.log(Level.SEVERE, "Unable to set Message Prefix for namespace " + this._namespace, iae);
            }
        }
        if (!prefixSet) {
            String prefix = ObjectStoreManager.getObjectStore((String)this._namespace).getString(MESSAGE_PREFIX_KEY);
            ResourceBundleManager.setPrefix((String)this._namespace, (String)(StringUtil.isNullOrEmpty((String)prefix) ? ObjectStoreManager.getObjectStore((String)"wizard-internal").getString(MESSAGE_PREFIX_KEY) : prefix));
        }
    }
}

