/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizardx.gui.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class MultiLineTableHeaderRenderer
extends JTextPane
implements TableCellRenderer {
    protected JTable _table;
    protected JPanel _panel;

    public MultiLineTableHeaderRenderer(JTable table) {
        this._table = table;
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this._panel = new JPanel(new BorderLayout());
        this._panel.add((Component)this, "Center");
        this._panel.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("TableHeader.cellBorder"), new EmptyBorder(4, 4, 4, 4)));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String header = value.toString();
        this.setText(header);
        this.setFont(UIManager.getFont("Label.font"));
        StyledDocument doc = this.getStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, 1);
        doc.setParagraphAttributes(0, doc.getLength(), center, false);
        return this._panel;
    }

    @Override
    public Dimension getPreferredSize() {
        int colWidth = this._table.getWidth() / this._table.getColumnCount();
        this.setSize(colWidth, Integer.MAX_VALUE);
        Dimension d = super.getPreferredSize();
        d.width = colWidth;
        return d;
    }
}

